%------------------------------------------------------------------------------
% File     : CSR153^2 : TPTP v9.2.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Is there a common relation?
% Version  : Especial > Reduced > Especial.
% English  : Mary, Sue, Bill and Bob are mutually distinct. Mary is neither a
%            sister of Sue nor of Bill. Bob is not a brother of Mary. Sue is a
%            sister of Bill and of Bob. Bob is a brother of Bill. Is there a 
%            relation that holds both between Bob and Bill and between Sue and 
%            Bob?

% Refs     : [PS07]  Pease & Sutcliffe (2007), First Order Reasoning on a L
%          : [BP10]  Benzmueller & Pease (2010), Progress in Automating Hig
%          : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : paar_9.tq_SUMO_sine [Ben10]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.25 v9.0.0, 0.30 v8.2.0, 0.54 v8.1.0, 0.45 v7.5.0, 0.14 v7.4.0, 0.33 v7.2.0, 0.25 v7.1.0, 0.38 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.40 v6.2.0, 0.43 v6.1.0, 0.71 v6.0.0, 0.57 v5.5.0, 0.67 v5.4.0, 0.80 v5.3.0, 1.00 v5.2.0, 0.80 v5.1.0, 1.00 v4.1.0
% Syntax   : Number of formulae    :  194 (  48 unt;  65 typ;   0 def)
%            Number of atoms       :  262 (  21 equ;  21 cnn)
%            Maximal formula atoms :    9 (   2 avg)
%            Number of connectives :  528 (  21   ~;   2   |;  34   &; 432   @)
%                                         (   7 <=>;  32  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   4 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   90 (  90   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   66 (  64 usr;  36 con; 0-3 aty)
%            Number of variables   :   86 (   0   ^;  82   !;   4   ?;  86   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2TH0 translator into THF syntax.
%          : The translation has been applied in two modes: local and SInE.
%            The local mode only translates the local assumptions and the
%            query. The SInE mode additionally translates the SInE-extract
%            of the loaded knowledge base (usually SUMO).
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%------------------------------------------------------------------------------
%----The extracted Signature
thf(numbers,type,
    num: $tType ).

thf(agent_THFTYPE_i,type,
    agent_THFTYPE_i: $i ).

thf(attribute_THFTYPE_i,type,
    attribute_THFTYPE_i: $i ).

thf(before_THFTYPE_IiioI,type,
    before_THFTYPE_IiioI: $i > $i > $o ).

thf(brother_THFTYPE_IiioI,type,
    brother_THFTYPE_IiioI: $i > $i > $o ).

thf(connected_THFTYPE_i,type,
    connected_THFTYPE_i: $i ).

thf(disjoint_THFTYPE_IiioI,type,
    disjoint_THFTYPE_IiioI: $i > $i > $o ).

thf(domain_THFTYPE_IIiiIiioI,type,
    domain_THFTYPE_IIiiIiioI: ( $i > $i ) > $i > $i > $o ).

thf(domain_THFTYPE_IIiioIiioI,type,
    domain_THFTYPE_IIiioIiioI: ( $i > $i > $o ) > $i > $i > $o ).

thf(domain_THFTYPE_IiiioI,type,
    domain_THFTYPE_IiiioI: $i > $i > $i > $o ).

thf(equal_THFTYPE_i,type,
    equal_THFTYPE_i: $i ).

thf(familyRelation_THFTYPE_i,type,
    familyRelation_THFTYPE_i: $i ).

thf(greaterThan_THFTYPE_i,type,
    greaterThan_THFTYPE_i: $i ).

thf(holdsDuring_THFTYPE_IiooI,type,
    holdsDuring_THFTYPE_IiooI: $i > $o > $o ).

thf(instance_THFTYPE_IIIiioIIiioIoIioI,type,
    instance_THFTYPE_IIIiioIIiioIoIioI: ( ( $i > $i > $o ) > ( $i > $i > $o ) > $o ) > $i > $o ).

thf(instance_THFTYPE_IIiiIioI,type,
    instance_THFTYPE_IIiiIioI: ( $i > $i ) > $i > $o ).

thf(instance_THFTYPE_IIiioIioI,type,
    instance_THFTYPE_IIiioIioI: ( $i > $i > $o ) > $i > $o ).

thf(instance_THFTYPE_IIiooIioI,type,
    instance_THFTYPE_IIiooIioI: ( $i > $o > $o ) > $i > $o ).

thf(instance_THFTYPE_IiioI,type,
    instance_THFTYPE_IiioI: $i > $i > $o ).

thf(lAsymmetricRelation_THFTYPE_i,type,
    lAsymmetricRelation_THFTYPE_i: $i ).

thf(lBeginFn_THFTYPE_IiiI,type,
    lBeginFn_THFTYPE_IiiI: $i > $i ).

thf(lBeginFn_THFTYPE_i,type,
    lBeginFn_THFTYPE_i: $i ).

thf(lBill_THFTYPE_i,type,
    lBill_THFTYPE_i: $i ).

thf(lBinaryPredicate_THFTYPE_i,type,
    lBinaryPredicate_THFTYPE_i: $i ).

thf(lBob_THFTYPE_i,type,
    lBob_THFTYPE_i: $i ).

thf(lEndFn_THFTYPE_IiiI,type,
    lEndFn_THFTYPE_IiiI: $i > $i ).

thf(lEndFn_THFTYPE_i,type,
    lEndFn_THFTYPE_i: $i ).

thf(lEquivalenceRelation_THFTYPE_i,type,
    lEquivalenceRelation_THFTYPE_i: $i ).

thf(lHuman_THFTYPE_i,type,
    lHuman_THFTYPE_i: $i ).

thf(lIrreflexiveRelation_THFTYPE_i,type,
    lIrreflexiveRelation_THFTYPE_i: $i ).

thf(lMary_THFTYPE_i,type,
    lMary_THFTYPE_i: $i ).

thf(lMeasureFn_THFTYPE_i,type,
    lMeasureFn_THFTYPE_i: $i ).

thf(lMultiplicationFn_THFTYPE_i,type,
    lMultiplicationFn_THFTYPE_i: $i ).

thf(lObject_THFTYPE_i,type,
    lObject_THFTYPE_i: $i ).

thf(lOrganism_THFTYPE_i,type,
    lOrganism_THFTYPE_i: $i ).

thf(lProcess_THFTYPE_i,type,
    lProcess_THFTYPE_i: $i ).

thf(lQuantity_THFTYPE_i,type,
    lQuantity_THFTYPE_i: $i ).

thf(lSue_THFTYPE_i,type,
    lSue_THFTYPE_i: $i ).

thf(lSymmetricRelation_THFTYPE_i,type,
    lSymmetricRelation_THFTYPE_i: $i ).

thf(lTemporalRelation_THFTYPE_i,type,
    lTemporalRelation_THFTYPE_i: $i ).

thf(lTimeInterval_THFTYPE_i,type,
    lTimeInterval_THFTYPE_i: $i ).

thf(lTimePoint_THFTYPE_i,type,
    lTimePoint_THFTYPE_i: $i ).

thf(lTotalValuedRelation_THFTYPE_i,type,
    lTotalValuedRelation_THFTYPE_i: $i ).

thf(lTransitiveRelation_THFTYPE_i,type,
    lTransitiveRelation_THFTYPE_i: $i ).

thf(lUnaryFunction_THFTYPE_i,type,
    lUnaryFunction_THFTYPE_i: $i ).

thf(lWhenFn_THFTYPE_IiiI,type,
    lWhenFn_THFTYPE_IiiI: $i > $i ).

thf(lWhenFn_THFTYPE_i,type,
    lWhenFn_THFTYPE_i: $i ).

thf(located_THFTYPE_IiioI,type,
    located_THFTYPE_IiioI: $i > $i > $o ).

thf(meetsTemporally_THFTYPE_IiioI,type,
    meetsTemporally_THFTYPE_IiioI: $i > $i > $o ).

thf(n1_THFTYPE_i,type,
    n1_THFTYPE_i: $i ).

thf(n2_THFTYPE_i,type,
    n2_THFTYPE_i: $i ).

thf(parent_THFTYPE_IiioI,type,
    parent_THFTYPE_IiioI: $i > $i > $o ).

thf(part_THFTYPE_IiioI,type,
    part_THFTYPE_IiioI: $i > $i > $o ).

thf(patient_THFTYPE_i,type,
    patient_THFTYPE_i: $i ).

thf(range_THFTYPE_IiioI,type,
    range_THFTYPE_IiioI: $i > $i > $o ).

thf(relatedInternalConcept_THFTYPE_i,type,
    relatedInternalConcept_THFTYPE_i: $i ).

thf(sibling_THFTYPE_IiioI,type,
    sibling_THFTYPE_IiioI: $i > $i > $o ).

thf(sister_THFTYPE_IiioI,type,
    sister_THFTYPE_IiioI: $i > $i > $o ).

thf(subProcess_THFTYPE_IiioI,type,
    subProcess_THFTYPE_IiioI: $i > $i > $o ).

thf(subclass_THFTYPE_IiioI,type,
    subclass_THFTYPE_IiioI: $i > $i > $o ).

thf(subrelation_THFTYPE_IIiioIIiioIoI,type,
    subrelation_THFTYPE_IIiioIIiioIoI: ( $i > $i > $o ) > ( $i > $i > $o ) > $o ).

thf(subrelation_THFTYPE_IIiioIioI,type,
    subrelation_THFTYPE_IIiioIioI: ( $i > $i > $o ) > $i > $o ).

thf(subrelation_THFTYPE_IIioIIioIoI,type,
    subrelation_THFTYPE_IIioIIioIoI: ( $i > $o ) > ( $i > $o ) > $o ).

thf(subrelation_THFTYPE_IiioI,type,
    subrelation_THFTYPE_IiioI: $i > $i > $o ).

thf(temporalPart_THFTYPE_IiioI,type,
    temporalPart_THFTYPE_IiioI: $i > $i > $o ).

%----The translated axioms
%KIF documentation:(documentation instance EnglishLanguage "An object is an &%instance of a &%SetOrClass if it is included in that &%SetOrClass. An individual may be an instance of many classes, some of which may be subclasses of others. Thus, there is no assumption in the meaning of &%instance about specificity or uniqueness.")
%KIF documentation:(documentation range EnglishLanguage "Gives the range of a function. In other words, (&%range ?FUNCTION ?CLASS) means that all of the values assigned by ?FUNCTION are &%instances of ?CLASS.")
%KIF documentation:(documentation Process EnglishLanguage "The class of things that happen and have temporal parts or stages. Examples include extended events like a football match or a race, actions like &%Pursuing and &%Reading, and biological processes. The formal definition is: anything that occurs in time but is not an &%Object. Note that a &%Process may have participants 'inside' it which are &%Objects, such as the players in a football match. In a 4D ontology, a &%Process is something whose spatiotemporal extent is thought of as dividing into temporal stages roughly perpendicular to the time-axis.")
thf(ax,axiom,
    ! [X: $i,Y: $i,Z: $i] :
      ( ( ( subclass_THFTYPE_IiioI @ X @ Y )
        & ( instance_THFTYPE_IiioI @ Z @ X ) )
     => ( instance_THFTYPE_IiioI @ Z @ Y ) ) ).

%KIF documentation:(documentation TemporalRelation EnglishLanguage "The &%Class of temporal &%Relations. This &%Class includes notions of (temporal) topology of intervals, (temporal) schemata, and (temporal) extension.")
%KIF documentation:(documentation familyRelation EnglishLanguage "A very general &%Predicate for biological relationships. (&%familyRelation ?ORGANISM1 ?ORGANISM2) means that ?ORGANISM1 and ?ORGANISM2 are biologically derived from a common ancestor.")
%KIF documentation:(documentation IrreflexiveRelation EnglishLanguage "&%Relation ?REL is irreflexive iff (?REL ?INST ?INST) holds for no value of ?INST.")
%KIF documentation:(documentation sibling EnglishLanguage "The relationship between two &%Organisms that have the same &%mother and &%father. Note that this relationship does not hold between half-brothers, half-sisters, etc.")
thf(ax_001,axiom,
    (~) @ ( lBob_THFTYPE_i = lBill_THFTYPE_i ) ).

thf(ax_002,axiom,
    (~) @ ( lBob_THFTYPE_i = lBill_THFTYPE_i ) ).

%KIF documentation:(documentation TimePoint EnglishLanguage "An extensionless point on the universal timeline. The &%TimePoints at which &%Processes occur can be known with various degrees of precision and approximation, but conceptually &%TimePoints are point-like and not interval-like. That is, it doesn't make sense to talk about how long a &%TimePoint lasts.")
thf(ax_003,axiom,
    ! [CLASS1: $i,CLASS2: $i] :
      ( ( CLASS1 = CLASS2 )
     => ! [THING: $i] :
          ( ( instance_THFTYPE_IiioI @ THING @ CLASS1 )
        <=> ( instance_THFTYPE_IiioI @ THING @ CLASS2 ) ) ) ).

%KIF documentation:(documentation TotalValuedRelation EnglishLanguage "A &%Relation is a &%TotalValuedRelation just in case there exists an assignment for the last argument position of the &%Relation given any assignment of values to every argument position except the last one. Note that declaring a &%Relation to be both a &%TotalValuedRelation and a &%SingleValuedRelation means that it is a total function.")
%KIF documentation:(documentation AsymmetricRelation EnglishLanguage "A &%BinaryRelation is asymmetric if and only if it is both an &%AntisymmetricRelation and an &%IrreflexiveRelation.")
%KIF documentation:(documentation Quantity EnglishLanguage "Any specification of how many or how much of something there is. Accordingly, there are two subclasses of &%Quantity: &%Number (how many) and &%PhysicalQuantity (how much).")
thf(ax_004,axiom,
    ( ( (~) @ ( sister_THFTYPE_IiioI @ lMary_THFTYPE_i @ lSue_THFTYPE_i ) )
    & ( (~) @ ( sister_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i ) )
    & ( (~) @ ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lMary_THFTYPE_i ) ) ) ).

%KIF documentation:(documentation EquivalenceRelation EnglishLanguage "A &%BinaryRelation is an equivalence relation if it is a &%ReflexiveRelation, a &%SymmetricRelation, and a &%TransitiveRelation.")
thf(ax_005,axiom,
    ! [REL2: $i > $o,ROW: $i,REL1: $i > $o] :
      ( ( ( subrelation_THFTYPE_IIioIIioIoI @ REL1 @ REL2 )
        & ( REL1 @ ROW ) )
     => ( REL2 @ ROW ) ) ).

thf(ax_006,axiom,
    ! [OBJ1: $i,OBJ2: $i] :
      ( ( located_THFTYPE_IiioI @ OBJ1 @ OBJ2 )
     => ! [SUB: $i] :
          ( ( part_THFTYPE_IiioI @ SUB @ OBJ1 )
         => ( located_THFTYPE_IiioI @ SUB @ OBJ2 ) ) ) ).

%KIF documentation:(documentation disjoint EnglishLanguage "&%Classes are &%disjoint only if they share no instances, i.e. just in case the result of applying &%IntersectionFn to them is empty.")
%KIF documentation:(documentation subProcess EnglishLanguage "(&%subProcess ?SUBPROC ?PROC) means that ?SUBPROC is a subprocess of ?PROC. A subprocess is here understood as a temporally distinguished part (proper or not) of a &%Process.")
thf(ax_007,axiom,
    ! [INTERVAL: $i] :
      ( ( instance_THFTYPE_IiioI @ INTERVAL @ lTimeInterval_THFTYPE_i )
     => ( before_THFTYPE_IiioI @ ( lBeginFn_THFTYPE_IiiI @ INTERVAL ) @ ( lEndFn_THFTYPE_IiiI @ INTERVAL ) ) ) ).

%KIF documentation:(documentation MultiplicationFn EnglishLanguage "If ?NUMBER1 and ?NUMBER2 are &%Numbers, then (&%MultiplicationFn ?NUMBER1 ?NUMBER2) is the arithmetical product of these numbers.")
thf(ax_008,axiom,
    range_THFTYPE_IiioI @ lEndFn_THFTYPE_i @ lTimePoint_THFTYPE_i ).

thf(ax_009,axiom,
    ! [THING2: $i,THING1: $i] :
      ( ( THING1 = THING2 )
     => ! [CLASS: $i] :
          ( ( instance_THFTYPE_IiioI @ THING1 @ CLASS )
        <=> ( instance_THFTYPE_IiioI @ THING2 @ CLASS ) ) ) ).

thf(ax_010,axiom,
    ! [CLASS1: $i,REL: $i,CLASS2: $i] :
      ( ( ( range_THFTYPE_IiioI @ REL @ CLASS1 )
        & ( range_THFTYPE_IiioI @ REL @ CLASS2 ) )
     => ( ( subclass_THFTYPE_IiioI @ CLASS1 @ CLASS2 )
        | ( subclass_THFTYPE_IiioI @ CLASS2 @ CLASS1 ) ) ) ).

%KIF documentation:(documentation domain EnglishLanguage "Provides a computationally and heuristically convenient mechanism for declaring the argument types of a given relation. The formula (&%domain ?REL ?INT ?CLASS) means that the ?INT'th element of each tuple in the relation ?REL must be an instance of ?CLASS. Specifying argument types is very helpful in maintaining ontologies. Representation systems can use these specifications to classify terms and check integrity constraints. If the restriction on the argument type of a &%Relation is not captured by a &%SetOrClass already defined in the ontology, one can specify a &%SetOrClass compositionally with the functions &%UnionFn, &%IntersectionFn, etc.")
thf(ax_011,axiom,
    ! [CLASS1: $i,CLASS2: $i] :
      ( ( disjoint_THFTYPE_IiioI @ CLASS1 @ CLASS2 )
    <=> ! [INST: $i] :
          ( (~)
          @ ( ( instance_THFTYPE_IiioI @ INST @ CLASS1 )
            & ( instance_THFTYPE_IiioI @ INST @ CLASS2 ) ) ) ) ).

%KIF documentation:(documentation UnaryFunction EnglishLanguage "The &%Class of &%Functions that require a single argument.")
thf(ax_012,axiom,
    ! [SUBPROC: $i,PROC: $i] :
      ( ( subProcess_THFTYPE_IiioI @ SUBPROC @ PROC )
     => ( temporalPart_THFTYPE_IiioI @ ( lWhenFn_THFTYPE_IiiI @ SUBPROC ) @ ( lWhenFn_THFTYPE_IiiI @ PROC ) ) ) ).

%KIF documentation:(documentation connected EnglishLanguage "(connected ?OBJ1 ?OBJ2) means that ?OBJ1 &%meetsSpatially ?OBJ2 or that ?OBJ1 &%overlapsSpatially ?OBJ2.")
%KIF documentation:(documentation brother EnglishLanguage "The general relationship of being a brother. (&%brother ?MAN ?PERSON) means that ?MAN is the brother of ?PERSON.")
%KIF documentation:(documentation TimeInterval EnglishLanguage "An interval of time. Note that a &%TimeInterval has both an extent and a location on the universal timeline. Note too that a &%TimeInterval has no gaps, i.e. this class contains only convex time intervals.")
%KIF documentation:(documentation relatedInternalConcept EnglishLanguage "Means that the two arguments are related concepts within the SUMO, i.e. there is a significant similarity of meaning between them. To indicate a meaning relation between a SUMO concept and a concept from another source, use the Predicate &%relatedExternalConcept.")
thf(ax_013,axiom,
    ! [CLASS: $i,CHILD: $i,PARENT: $i] :
      ( ( ( parent_THFTYPE_IiioI @ CHILD @ PARENT )
        & ( subclass_THFTYPE_IiioI @ CLASS @ lOrganism_THFTYPE_i )
        & ( instance_THFTYPE_IiioI @ PARENT @ CLASS ) )
     => ( instance_THFTYPE_IiioI @ CHILD @ CLASS ) ) ).

thf(ax_014,axiom,
    ! [INTERVAL1: $i,INTERVAL2: $i] :
      ( ( ( ( lBeginFn_THFTYPE_IiiI @ INTERVAL1 )
          = ( lBeginFn_THFTYPE_IiiI @ INTERVAL2 ) )
        & ( ( lEndFn_THFTYPE_IiiI @ INTERVAL1 )
          = ( lEndFn_THFTYPE_IiiI @ INTERVAL2 ) ) )
     => ( INTERVAL1 = INTERVAL2 ) ) ).

%KIF documentation:(documentation BinaryPredicate EnglishLanguage "A &%Predicate relating two items - its valence is two.")
thf(ax_015,axiom,
    subclass_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i @ lIrreflexiveRelation_THFTYPE_i ).

thf(ax_016,axiom,
    ! [REL2: $i,CLASS1: $i,REL1: $i] :
      ( ( ( subrelation_THFTYPE_IiioI @ REL1 @ REL2 )
        & ( range_THFTYPE_IiioI @ REL2 @ CLASS1 ) )
     => ( range_THFTYPE_IiioI @ REL1 @ CLASS1 ) ) ).

%KIF documentation:(documentation subclass EnglishLanguage "(&%subclass ?CLASS1 ?CLASS2) means that ?CLASS1 is a subclass of ?CLASS2, i.e. every instance of ?CLASS1 is also an instance of ?CLASS2. A class may have multiple superclasses and subclasses.")
%KIF documentation:(documentation MeasureFn EnglishLanguage "This &%BinaryFunction maps a &%RealNumber and a &%UnitOfMeasure to that &%Number of units. It is used to express `measured' instances of &%PhysicalQuantity. Example: the concept of three meters is represented as (&%MeasureFn 3 &%Meter).")
%KIF documentation:(documentation part EnglishLanguage "The basic mereological relation. All other mereological relations are defined in terms of this one. (&%part ?PART ?WHOLE) simply means that the &%Object ?PART is part of the &%Object ?WHOLE. Note that, since &%part is a &%ReflexiveRelation, every &%Object is a part of itself.")
%KIF documentation:(documentation WhenFn EnglishLanguage "A &%UnaryFunction that maps an &%Object or &%Process to the exact &%TimeInterval during which it exists. Note that, for every &%TimePoint ?TIME outside of the &%TimeInterval (WhenFn ?THING), (time ?THING ?TIME) does not hold.")
%KIF documentation:(documentation documentation EnglishLanguage "A relation between objects in the domain of discourse and strings of natural language text stated in a particular &%HumanLanguage. The domain of &%documentation is not constants (names), but the objects themselves. This means that one does not quote the names when associating them with their documentation.")
thf(ax_017,axiom,
    range_THFTYPE_IiioI @ lBeginFn_THFTYPE_i @ lTimePoint_THFTYPE_i ).

thf(ax_018,axiom,
    ! [NUMBER: $i,CLASS1: $i,REL: $i,CLASS2: $i] :
      ( ( ( domain_THFTYPE_IiiioI @ REL @ NUMBER @ CLASS1 )
        & ( domain_THFTYPE_IiiioI @ REL @ NUMBER @ CLASS2 ) )
     => ( ( subclass_THFTYPE_IiioI @ CLASS1 @ CLASS2 )
        | ( subclass_THFTYPE_IiioI @ CLASS2 @ CLASS1 ) ) ) ).

thf(ax_019,axiom,
    ( ( (~) @ ( lMary_THFTYPE_i = lSue_THFTYPE_i ) )
    & ( (~) @ ( lMary_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( (~) @ ( lBob_THFTYPE_i = lMary_THFTYPE_i ) ) ) ).

thf(ax_020,axiom,
    ( ( (~) @ ( lSue_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( (~) @ ( lSue_THFTYPE_i = lBob_THFTYPE_i ) ) ) ).

thf(ax_021,axiom,
    ( ( (~) @ ( lSue_THFTYPE_i = lBill_THFTYPE_i ) )
    & ( (~) @ ( lSue_THFTYPE_i = lBob_THFTYPE_i ) ) ) ).

%KIF documentation:(documentation SymmetricRelation EnglishLanguage "A &%BinaryRelation ?REL is symmetric just iff (?REL ?INST1 ?INST2) imples (?REL ?INST2 ?INST1), for all ?INST1 and ?INST2.")
%KIF documentation:(documentation parent EnglishLanguage "The general relationship of parenthood. (&%parent ?CHILD ?PARENT) means that ?PARENT is a biological parent of ?CHILD.")
%KIF documentation:(documentation agent EnglishLanguage "(&%agent ?PROCESS ?AGENT) means that ?AGENT is an active determinant, either animate or inanimate, of the &%Process ?PROCESS, with or without voluntary intention. For example, Eve is an &%agent in the following proposition: Eve bit an apple.")
thf(ax_022,axiom,
    ! [REL: $i > $i > $o] :
      ( ( instance_THFTYPE_IIiioIioI @ REL @ lTransitiveRelation_THFTYPE_i )
    <=> ! [INST1: $i,INST2: $i,INST3: $i] :
          ( ( ( REL @ INST1 @ INST2 )
            & ( REL @ INST2 @ INST3 ) )
         => ( REL @ INST1 @ INST3 ) ) ) ).

thf(ax_023,axiom,
    ! [SUBPROC: $i,PROC: $i] :
      ( ( subProcess_THFTYPE_IiioI @ SUBPROC @ PROC )
     => ! [REGION: $i] :
          ( ( located_THFTYPE_IiioI @ PROC @ REGION )
         => ( located_THFTYPE_IiioI @ SUBPROC @ REGION ) ) ) ).

thf(ax_024,axiom,
    ! [POINT: $i,INTERVAL: $i] :
      ( ( ( lBeginFn_THFTYPE_IiiI @ INTERVAL )
        = POINT )
     => ! [OTHERPOINT: $i] :
          ( ( ( temporalPart_THFTYPE_IiioI @ OTHERPOINT @ INTERVAL )
            & ( (~) @ ( OTHERPOINT = POINT ) ) )
         => ( before_THFTYPE_IiioI @ POINT @ OTHERPOINT ) ) ) ).

%KIF documentation:(documentation BeginFn EnglishLanguage "A &%UnaryFunction that maps a &%TimeInterval to the &%TimePoint at which the interval begins.")
thf(ax_025,axiom,
    subclass_THFTYPE_IiioI @ lEquivalenceRelation_THFTYPE_i @ lSymmetricRelation_THFTYPE_i ).

%KIF documentation:(documentation EnglishLanguage EnglishLanguage "A Germanic language that incorporates many roots from the Romance languages. It is the official language of the &%UnitedStates, the &%UnitedKingdom, and many other countries.")
%KIF documentation:(documentation TransitiveRelation EnglishLanguage "A &%BinaryRelation ?REL is transitive if (?REL ?INST1 ?INST2) and (?REL ?INST2 ?INST3) imply (?REL ?INST1 ?INST3), for all ?INST1, ?INST2, and ?INST3.")
thf(ax_026,axiom,
    ! [POINT: $i] :
      ( ( instance_THFTYPE_IiioI @ POINT @ lTimePoint_THFTYPE_i )
     => ? [INTERVAL: $i] :
          ( ( instance_THFTYPE_IiioI @ INTERVAL @ lTimeInterval_THFTYPE_i )
          & ( temporalPart_THFTYPE_IiioI @ POINT @ INTERVAL ) ) ) ).

%KIF documentation:(documentation patient EnglishLanguage "(&%patient ?PROCESS ?ENTITY) means that ?ENTITY is a participant in ?PROCESS that may be moved, said, experienced, etc. For example, the direct objects in the sentences 'The cat swallowed the canary' and 'Billy likes the beer' would be examples of &%patients. Note that the &%patient of a &%Process may or may not undergo structural change as a result of the &%Process. The &%CaseRole of &%patient is used when one wants to specify as broadly as possible the object of a &%Process.")
%KIF documentation:(documentation equal EnglishLanguage "(equal ?ENTITY1 ?ENTITY2) is true just in case ?ENTITY1 is identical with ?ENTITY2.")
thf(ax_027,axiom,
    ! [REL: $i > $i > $o] :
      ( ( instance_THFTYPE_IIiioIioI @ REL @ lSymmetricRelation_THFTYPE_i )
    <=> ! [INST1: $i,INST2: $i] :
          ( ( REL @ INST1 @ INST2 )
         => ( REL @ INST2 @ INST1 ) ) ) ).

thf(ax_028,axiom,
    ! [ORG1: $i,ORG2: $i,PARENT: $i] :
      ( ( ( sibling_THFTYPE_IiioI @ ORG1 @ ORG2 )
        & ( parent_THFTYPE_IiioI @ ORG1 @ PARENT ) )
     => ( parent_THFTYPE_IiioI @ ORG2 @ PARENT ) ) ).

thf(ax_029,axiom,
    ( ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i )
    & ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
    & ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lBill_THFTYPE_i ) ) ).

thf(ax_030,axiom,
    ( ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i )
    & ( sister_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
    & ( brother_THFTYPE_IiioI @ lBob_THFTYPE_i @ lBill_THFTYPE_i ) ) ).

%KIF documentation:(documentation before EnglishLanguage "(&%before ?POINT1 ?POINT2) means that ?POINT1 precedes ?POINT2 on the universal timeline.")
%KIF documentation:(documentation temporalPart EnglishLanguage "The temporal analogue of the spatial &%part predicate. (&%temporalPart ?POS1 ?POS2) means that &%TimePosition ?POS1 is part of &%TimePosition ?POS2. Note that since &%temporalPart is a &%ReflexiveRelation every &%TimePostion is a &%temporalPart of itself.")
%KIF documentation:(documentation subrelation EnglishLanguage "(&%subrelation ?REL1 ?REL2) means that every tuple of ?REL1 is also a tuple of ?REL2. In other words, if the &%Relation ?REL1 holds for some arguments arg_1, arg_2, ... arg_n, then the &%Relation ?REL2 holds for the same arguments. A consequence of this is that a &%Relation and its subrelations must have the same &%valence.")
thf(ax_031,axiom,
    ! [ORGANISM: $i] :
      ( ( instance_THFTYPE_IiioI @ ORGANISM @ lOrganism_THFTYPE_i )
     => ? [PARENT: $i] : ( parent_THFTYPE_IiioI @ ORGANISM @ PARENT ) ) ).

thf(ax_032,axiom,
    ! [TIME: $i,SITUATION: $o] :
      ( ( holdsDuring_THFTYPE_IiooI @ TIME @ ( (~) @ SITUATION ) )
     => ( (~) @ ( holdsDuring_THFTYPE_IiooI @ TIME @ SITUATION ) ) ) ).

%KIF documentation:(documentation holdsDuring EnglishLanguage "(&%holdsDuring ?TIME ?FORMULA) means that the proposition denoted by ?FORMULA is true in the time frame ?TIME. Note that this implies that ?FORMULA is true at every &%TimePoint which is a &%temporalPart of ?TIME.")
%KIF documentation:(documentation EndFn EnglishLanguage "A &%UnaryFunction that maps a &%TimeInterval to the &%TimePoint at which the interval ends.")
%KIF documentation:(documentation meetsTemporally EnglishLanguage "(&%meetsTemporally ?INTERVAL1 ?INTERVAL2) means that the terminal point of the &%TimeInterval ?INTERVAL1 is the initial point of the &%TimeInterval ?INTERVAL2.")
thf(ax_033,axiom,
    ! [POINT: $i,INTERVAL: $i] :
      ( ( ( lEndFn_THFTYPE_IiiI @ INTERVAL )
        = POINT )
     => ! [OTHERPOINT: $i] :
          ( ( ( temporalPart_THFTYPE_IiioI @ OTHERPOINT @ INTERVAL )
            & ( (~) @ ( OTHERPOINT = POINT ) ) )
         => ( before_THFTYPE_IiioI @ OTHERPOINT @ POINT ) ) ) ).

%KIF documentation:(documentation attribute EnglishLanguage "(&%attribute ?OBJECT ?PROPERTY) means that ?PROPERTY is a &%Attribute of ?OBJECT. For example, (&%attribute &%MyLittleRedWagon &%Red).")
thf(ax_034,axiom,
    ! [OBJ: $i,PROCESS: $i] :
      ( ( located_THFTYPE_IiioI @ PROCESS @ OBJ )
     => ! [SUB: $i] :
          ( ( subProcess_THFTYPE_IiioI @ SUB @ PROCESS )
         => ( located_THFTYPE_IiioI @ SUB @ OBJ ) ) ) ).

thf(ax_035,axiom,
    range_THFTYPE_IiioI @ lWhenFn_THFTYPE_i @ lTimeInterval_THFTYPE_i ).

%KIF documentation:(documentation greaterThan EnglishLanguage "(&%greaterThan ?NUMBER1 ?NUMBER2) is true just in case the &%Quantity ?NUMBER1 is greater than the &%Quantity ?NUMBER2.")
thf(ax_036,axiom,
    ! [INTERVAL: $i] :
      ( ( instance_THFTYPE_IiioI @ INTERVAL @ lTimeInterval_THFTYPE_i )
     => ? [POINT: $i] :
          ( ( instance_THFTYPE_IiioI @ POINT @ lTimePoint_THFTYPE_i )
          & ( temporalPart_THFTYPE_IiioI @ POINT @ INTERVAL ) ) ) ).

%KIF documentation:(documentation Organism EnglishLanguage "Generally, a living individual, including all &%Plants and &%Animals.")
thf(ax_037,axiom,
    ! [PARENT2: $i,ORGANISM1: $i,ORGANISM2: $i,PARENT1: $i] :
      ( ( ( parent_THFTYPE_IiioI @ ORGANISM1 @ PARENT1 )
        & ( parent_THFTYPE_IiioI @ ORGANISM2 @ PARENT1 )
        & ( parent_THFTYPE_IiioI @ ORGANISM1 @ PARENT2 )
        & ( parent_THFTYPE_IiioI @ ORGANISM2 @ PARENT2 )
        & ( (~) @ ( ORGANISM1 = ORGANISM2 ) )
        & ( (~) @ ( PARENT1 = PARENT2 ) ) )
     => ( sibling_THFTYPE_IiioI @ ORGANISM1 @ ORGANISM2 ) ) ).

thf(ax_038,axiom,
    ! [INTERVAL1: $i,INTERVAL2: $i] :
      ( ( meetsTemporally_THFTYPE_IiioI @ INTERVAL1 @ INTERVAL2 )
    <=> ( ( lEndFn_THFTYPE_IiiI @ INTERVAL1 )
        = ( lBeginFn_THFTYPE_IiiI @ INTERVAL2 ) ) ) ).

thf(ax_039,axiom,
    ! [SITUATION: $o,TIME2: $i,TIME1: $i] :
      ( ( ( holdsDuring_THFTYPE_IiooI @ TIME1 @ SITUATION )
        & ( temporalPart_THFTYPE_IiioI @ TIME2 @ TIME1 ) )
     => ( holdsDuring_THFTYPE_IiooI @ TIME2 @ SITUATION ) ) ).

thf(ax_040,axiom,
    subclass_THFTYPE_IiioI @ lEquivalenceRelation_THFTYPE_i @ lTransitiveRelation_THFTYPE_i ).

thf(ax_041,axiom,
    range_THFTYPE_IiioI @ lMultiplicationFn_THFTYPE_i @ lQuantity_THFTYPE_i ).

%KIF documentation:(documentation Human EnglishLanguage "Modern man, the only remaining species of the Homo genus.")
%KIF documentation:(documentation sister EnglishLanguage "The general relationship of being a sister. (&%sister ?WOMAN ?PERSON) means that ?WOMAN is the sister of ?PERSON.")
thf(ax_042,axiom,
    ! [REL: $i > $i > $o] :
      ( ( instance_THFTYPE_IIiioIioI @ REL @ lIrreflexiveRelation_THFTYPE_i )
    <=> ! [INST: $i] : ( (~) @ ( REL @ INST @ INST ) ) ) ).

%KIF documentation:(documentation Object EnglishLanguage "Corresponds roughly to the class of ordinary objects. Examples include normal physical objects, geographical regions, and locations of &%Processes, the complement of &%Objects in the &%Physical class. In a 4D ontology, an &%Object is something whose spatiotemporal extent is thought of as dividing into spatial parts roughly parallel to the time-axis.")
thf(ax_043,axiom,
    ! [NUMBER: $i,PRED1: $i,CLASS1: $i,PRED2: $i] :
      ( ( ( subrelation_THFTYPE_IiioI @ PRED1 @ PRED2 )
        & ( domain_THFTYPE_IiiioI @ PRED2 @ NUMBER @ CLASS1 ) )
     => ( domain_THFTYPE_IiiioI @ PRED1 @ NUMBER @ CLASS1 ) ) ).

%KIF documentation:(documentation located EnglishLanguage "(&%located ?PHYS ?OBJ) means that ?PHYS is &%partlyLocated at ?OBJ, and there is no &%part or &%subProcess of ?PHYS that is not &%located at ?OBJ.")
thf(ax_044,axiom,
    ! [CHILD: $i,PARENT: $i] :
      ( ( parent_THFTYPE_IiioI @ CHILD @ PARENT )
     => ( before_THFTYPE_IiioI @ ( lBeginFn_THFTYPE_IiiI @ ( lWhenFn_THFTYPE_IiiI @ PARENT ) ) @ ( lBeginFn_THFTYPE_IiiI @ ( lWhenFn_THFTYPE_IiiI @ CHILD ) ) ) ) ).

thf(ax_045,axiom,
    instance_THFTYPE_IIiioIioI @ meetsTemporally_THFTYPE_IiioI @ lTemporalRelation_THFTYPE_i ).

thf(ax_046,axiom,
    instance_THFTYPE_IiioI @ connected_THFTYPE_i @ lBinaryPredicate_THFTYPE_i ).

thf(ax_047,axiom,
    instance_THFTYPE_IIiioIioI @ temporalPart_THFTYPE_IiioI @ lTemporalRelation_THFTYPE_i ).

thf(ax_048,axiom,
    instance_THFTYPE_IIiioIioI @ disjoint_THFTYPE_IiioI @ lSymmetricRelation_THFTYPE_i ).

thf(ax_049,axiom,
    instance_THFTYPE_IIiioIioI @ range_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i ).

thf(ax_050,axiom,
    domain_THFTYPE_IIiioIiioI @ sister_THFTYPE_IiioI @ n2_THFTYPE_i @ lHuman_THFTYPE_i ).

thf(ax_051,axiom,
    instance_THFTYPE_IIiioIioI @ range_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_052,axiom,
    instance_THFTYPE_IIiioIioI @ parent_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_053,axiom,
    instance_THFTYPE_IIiioIioI @ meetsTemporally_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i ).

thf(ax_054,axiom,
    instance_THFTYPE_IiioI @ equal_THFTYPE_i @ lEquivalenceRelation_THFTYPE_i ).

thf(ax_055,axiom,
    domain_THFTYPE_IIiioIiioI @ subProcess_THFTYPE_IiioI @ n1_THFTYPE_i @ lProcess_THFTYPE_i ).

thf(ax_056,axiom,
    instance_THFTYPE_IIiioIioI @ sibling_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_057,axiom,
    subrelation_THFTYPE_IIiioIIiioIoI @ sister_THFTYPE_IiioI @ sibling_THFTYPE_IiioI ).

thf(ax_058,axiom,
    instance_THFTYPE_IIiioIioI @ disjoint_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_059,axiom,
    instance_THFTYPE_IIiioIioI @ before_THFTYPE_IiioI @ lTemporalRelation_THFTYPE_i ).

thf(ax_060,axiom,
    instance_THFTYPE_IIiioIioI @ temporalPart_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_061,axiom,
    instance_THFTYPE_IIiioIioI @ brother_THFTYPE_IiioI @ lIrreflexiveRelation_THFTYPE_i ).

thf(ax_062,axiom,
    domain_THFTYPE_IIiioIiioI @ parent_THFTYPE_IiioI @ n1_THFTYPE_i @ lOrganism_THFTYPE_i ).

thf(ax_063,axiom,
    domain_THFTYPE_IIiioIiioI @ meetsTemporally_THFTYPE_IiioI @ n1_THFTYPE_i @ lTimeInterval_THFTYPE_i ).

thf(ax_064,axiom,
    instance_THFTYPE_IIiioIioI @ subProcess_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_065,axiom,
    domain_THFTYPE_IIiioIiioI @ sibling_THFTYPE_IiioI @ n1_THFTYPE_i @ lOrganism_THFTYPE_i ).

thf(ax_066,axiom,
    domain_THFTYPE_IiiioI @ familyRelation_THFTYPE_i @ n2_THFTYPE_i @ lOrganism_THFTYPE_i ).

thf(ax_067,axiom,
    instance_THFTYPE_IiioI @ greaterThan_THFTYPE_i @ lTransitiveRelation_THFTYPE_i ).

thf(ax_068,axiom,
    domain_THFTYPE_IiiioI @ familyRelation_THFTYPE_i @ n1_THFTYPE_i @ lOrganism_THFTYPE_i ).

thf(ax_069,axiom,
    instance_THFTYPE_IiioI @ greaterThan_THFTYPE_i @ lBinaryPredicate_THFTYPE_i ).

thf(ax_070,axiom,
    instance_THFTYPE_IIiiIioI @ lBeginFn_THFTYPE_IiiI @ lUnaryFunction_THFTYPE_i ).

thf(ax_071,axiom,
    domain_THFTYPE_IIiioIiioI @ parent_THFTYPE_IiioI @ n2_THFTYPE_i @ lOrganism_THFTYPE_i ).

thf(ax_072,axiom,
    instance_THFTYPE_IIiioIioI @ sister_THFTYPE_IiioI @ lIrreflexiveRelation_THFTYPE_i ).

thf(ax_073,axiom,
    domain_THFTYPE_IIiioIiioI @ before_THFTYPE_IiioI @ n1_THFTYPE_i @ lTimePoint_THFTYPE_i ).

thf(ax_074,axiom,
    domain_THFTYPE_IiiioI @ lMultiplicationFn_THFTYPE_i @ n2_THFTYPE_i @ lQuantity_THFTYPE_i ).

thf(ax_075,axiom,
    domain_THFTYPE_IIiioIiioI @ subProcess_THFTYPE_IiioI @ n2_THFTYPE_i @ lProcess_THFTYPE_i ).

thf(ax_076,axiom,
    instance_THFTYPE_IIiiIioI @ lBeginFn_THFTYPE_IiiI @ lTotalValuedRelation_THFTYPE_i ).

thf(ax_077,axiom,
    domain_THFTYPE_IiiioI @ agent_THFTYPE_i @ n1_THFTYPE_i @ lProcess_THFTYPE_i ).

thf(ax_078,axiom,
    instance_THFTYPE_IiioI @ equal_THFTYPE_i @ lBinaryPredicate_THFTYPE_i ).

thf(ax_079,axiom,
    instance_THFTYPE_IiioI @ relatedInternalConcept_THFTYPE_i @ lBinaryPredicate_THFTYPE_i ).

thf(ax_080,axiom,
    instance_THFTYPE_IIiioIioI @ meetsTemporally_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_081,axiom,
    instance_THFTYPE_IIiioIioI @ sister_THFTYPE_IiioI @ lTransitiveRelation_THFTYPE_i ).

thf(ax_082,axiom,
    instance_THFTYPE_IIiioIioI @ subclass_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_083,axiom,
    instance_THFTYPE_IiioI @ relatedInternalConcept_THFTYPE_i @ lEquivalenceRelation_THFTYPE_i ).

thf(ax_084,axiom,
    domain_THFTYPE_IIiioIiioI @ sibling_THFTYPE_IiioI @ n2_THFTYPE_i @ lOrganism_THFTYPE_i ).

thf(ax_085,axiom,
    domain_THFTYPE_IiiioI @ greaterThan_THFTYPE_i @ n2_THFTYPE_i @ lQuantity_THFTYPE_i ).

thf(ax_086,axiom,
    instance_THFTYPE_IiioI @ lEndFn_THFTYPE_i @ lUnaryFunction_THFTYPE_i ).

thf(ax_087,axiom,
    instance_THFTYPE_IiioI @ familyRelation_THFTYPE_i @ lEquivalenceRelation_THFTYPE_i ).

thf(ax_088,axiom,
    instance_THFTYPE_IiioI @ attribute_THFTYPE_i @ lAsymmetricRelation_THFTYPE_i ).

thf(ax_089,axiom,
    instance_THFTYPE_IIiiIioI @ lWhenFn_THFTYPE_IiiI @ lUnaryFunction_THFTYPE_i ).

thf(ax_090,axiom,
    instance_THFTYPE_IiioI @ lEndFn_THFTYPE_i @ lTemporalRelation_THFTYPE_i ).

thf(ax_091,axiom,
    domain_THFTYPE_IiiioI @ lMultiplicationFn_THFTYPE_i @ n1_THFTYPE_i @ lQuantity_THFTYPE_i ).

thf(ax_092,axiom,
    domain_THFTYPE_IiiioI @ patient_THFTYPE_i @ n1_THFTYPE_i @ lProcess_THFTYPE_i ).

thf(ax_093,axiom,
    instance_THFTYPE_IIiioIioI @ parent_THFTYPE_IiioI @ lAsymmetricRelation_THFTYPE_i ).

thf(ax_094,axiom,
    instance_THFTYPE_IIiioIioI @ before_THFTYPE_IiioI @ lTransitiveRelation_THFTYPE_i ).

thf(ax_095,axiom,
    instance_THFTYPE_IiioI @ lMultiplicationFn_THFTYPE_i @ lTotalValuedRelation_THFTYPE_i ).

thf(ax_096,axiom,
    instance_THFTYPE_IIiioIioI @ sibling_THFTYPE_IiioI @ lIrreflexiveRelation_THFTYPE_i ).

thf(ax_097,axiom,
    subrelation_THFTYPE_IIiioIIiioIoI @ brother_THFTYPE_IiioI @ sibling_THFTYPE_IiioI ).

thf(ax_098,axiom,
    instance_THFTYPE_IiioI @ lMeasureFn_THFTYPE_i @ lTotalValuedRelation_THFTYPE_i ).

thf(ax_099,axiom,
    domain_THFTYPE_IIiioIiioI @ before_THFTYPE_IiioI @ n2_THFTYPE_i @ lTimePoint_THFTYPE_i ).

thf(ax_100,axiom,
    instance_THFTYPE_IiioI @ connected_THFTYPE_i @ lSymmetricRelation_THFTYPE_i ).

thf(ax_101,axiom,
    instance_THFTYPE_IiioI @ familyRelation_THFTYPE_i @ lBinaryPredicate_THFTYPE_i ).

thf(ax_102,axiom,
    instance_THFTYPE_IiioI @ greaterThan_THFTYPE_i @ lIrreflexiveRelation_THFTYPE_i ).

thf(ax_103,axiom,
    instance_THFTYPE_IiioI @ lEndFn_THFTYPE_i @ lTotalValuedRelation_THFTYPE_i ).

thf(ax_104,axiom,
    domain_THFTYPE_IiiioI @ connected_THFTYPE_i @ n2_THFTYPE_i @ lObject_THFTYPE_i ).

thf(ax_105,axiom,
    domain_THFTYPE_IIiioIiioI @ meetsTemporally_THFTYPE_IiioI @ n2_THFTYPE_i @ lTimeInterval_THFTYPE_i ).

thf(ax_106,axiom,
    instance_THFTYPE_IIiioIioI @ before_THFTYPE_IiioI @ lIrreflexiveRelation_THFTYPE_i ).

thf(ax_107,axiom,
    instance_THFTYPE_IIiooIioI @ holdsDuring_THFTYPE_IiooI @ lAsymmetricRelation_THFTYPE_i ).

thf(ax_108,axiom,
    domain_THFTYPE_IIiioIiioI @ brother_THFTYPE_IiioI @ n2_THFTYPE_i @ lHuman_THFTYPE_i ).

thf(ax_109,axiom,
    instance_THFTYPE_IIiioIioI @ brother_THFTYPE_IiioI @ lTransitiveRelation_THFTYPE_i ).

thf(ax_110,axiom,
    instance_THFTYPE_IIIiioIIiioIoIioI @ subrelation_THFTYPE_IIiioIIiioIoI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_111,axiom,
    domain_THFTYPE_IiiioI @ lEndFn_THFTYPE_i @ n1_THFTYPE_i @ lTimeInterval_THFTYPE_i ).

thf(ax_112,axiom,
    domain_THFTYPE_IiiioI @ connected_THFTYPE_i @ n1_THFTYPE_i @ lObject_THFTYPE_i ).

thf(ax_113,axiom,
    domain_THFTYPE_IiiioI @ greaterThan_THFTYPE_i @ n1_THFTYPE_i @ lQuantity_THFTYPE_i ).

thf(ax_114,axiom,
    instance_THFTYPE_IIiiIioI @ lWhenFn_THFTYPE_IiiI @ lTotalValuedRelation_THFTYPE_i ).

thf(ax_115,axiom,
    domain_THFTYPE_IIiioIiioI @ part_THFTYPE_IiioI @ n1_THFTYPE_i @ lObject_THFTYPE_i ).

thf(ax_116,axiom,
    subrelation_THFTYPE_IIiioIioI @ parent_THFTYPE_IiioI @ familyRelation_THFTYPE_i ).

thf(ax_117,axiom,
    instance_THFTYPE_IIiiIioI @ lBeginFn_THFTYPE_IiiI @ lTemporalRelation_THFTYPE_i ).

thf(ax_118,axiom,
    domain_THFTYPE_IiiioI @ attribute_THFTYPE_i @ n1_THFTYPE_i @ lObject_THFTYPE_i ).

thf(ax_119,axiom,
    domain_THFTYPE_IIiiIiioI @ lBeginFn_THFTYPE_IiiI @ n1_THFTYPE_i @ lTimeInterval_THFTYPE_i ).

thf(ax_120,axiom,
    subrelation_THFTYPE_IIiioIioI @ sibling_THFTYPE_IiioI @ familyRelation_THFTYPE_i ).

thf(ax_121,axiom,
    instance_THFTYPE_IIiioIioI @ located_THFTYPE_IiioI @ lTransitiveRelation_THFTYPE_i ).

thf(ax_122,axiom,
    instance_THFTYPE_IIiioIioI @ instance_THFTYPE_IiioI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_123,axiom,
    instance_THFTYPE_IiioI @ attribute_THFTYPE_i @ lIrreflexiveRelation_THFTYPE_i ).

thf(ax_124,axiom,
    instance_THFTYPE_IIiioIioI @ sibling_THFTYPE_IiioI @ lSymmetricRelation_THFTYPE_i ).

thf(ax_125,axiom,
    instance_THFTYPE_IIiooIioI @ holdsDuring_THFTYPE_IiooI @ lBinaryPredicate_THFTYPE_i ).

thf(ax_126,axiom,
    instance_THFTYPE_IIiiIioI @ lWhenFn_THFTYPE_IiiI @ lTemporalRelation_THFTYPE_i ).

thf(ax_127,axiom,
    domain_THFTYPE_IIiioIiioI @ part_THFTYPE_IiioI @ n2_THFTYPE_i @ lObject_THFTYPE_i ).

%----The translated conjectures
thf(con,conjecture,
    ? [R: $i > $i > $o] :
      ( ( R @ lBob_THFTYPE_i @ lBill_THFTYPE_i )
      & ( R @ lSue_THFTYPE_i @ lBob_THFTYPE_i )
      & ( (~)
        @ ! [X: $i,Y: $i] : ( R @ X @ Y ) ) ) ).

%------------------------------------------------------------------------------
